<?php
$userId = $_SESSION['user_id'] ?? '';

$userDir = __DIR__ . "/users/$userId";
$userWebDir = "users/$userId";

$profilePic = "images/default-avatar.png";
$imgJpg = "$userDir/profile.jpg";
$imgPng = "$userDir/profile.png";

if (file_exists($imgJpg)) $profilePic = "$userWebDir/profile.jpg";
if (file_exists($imgPng)) $profilePic = "$userWebDir/profile.png";
?>

<div style="height: 60px;"></div>

<footer class="footer-nav">
    <div class="container">
        <a href="index.php" class="nav-icon" title="خانه">
            <i data-lucide="home" class="w-7 h-7"></i>
        </a>
        <a href="explore.php" class="nav-icon" title="جستجو">
            <i data-lucide="search" class="w-7 h-7"></i>
        </a>
        <?php if (!isset($_SESSION['user_id'])): ?>

            <a href="login.php" class="nav-icon" title="ورود">
                <i data-lucide="log-in" class="w-7 h-7"></i>
            </a>

        <?php else: ?>

            <a href="send_post.php" class="nav-icon" title="ارسال پست">
                <i data-lucide="circle-plus" class="w-7 h-7"></i>
            </a>

            <a href="profile.php" class="nav-icon" title="پروفایل">
                <img src="<?= $profilePic ?>?<?= time() ?>" class="w-7 h-7 rounded-full object-cover">
            </a>

        <?php endif; ?>
    </div>
</footer>

<style>
    .nav-icon.active {
        position: relative;
    }

    .nav-icon.active::after {
        content: "";
        position: absolute;
        bottom: -4px;
        left: 50%;
        transform: translateX(-50%);
        width: 20px;
        height: 2px;
        background: white;
        border-radius: 6px;
        opacity: 0.5;
    }
</style>

<script>
    document.addEventListener("DOMContentLoaded", () => {
        const currentPage = window.location.pathname.split("/").pop();

        document.querySelectorAll(".footer-nav .nav-icon").forEach(link => {
            const linkPage = link.getAttribute("href");

            if (linkPage === currentPage) {
                link.classList.add("active");
            }
        });
    });
</script>