<?php
require __DIR__ . "/session.php";

if (rate_limited()) {
    header("Location: ../../index.php");
    exit;
}

if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    $_SESSION['attempts']++;
    header("Location: ../../index.php");
    exit;
}

if (!isset($_POST["username"]) || !isset($_POST["password"])) {
    $_SESSION['attempts']++;
    header("Location: ../../index.php");
    exit;
}

$stored = require __DIR__ . "/../../secure/secret_login.php";

if (password_verify($_POST["username"], $stored["username_hash"]) &&
    password_verify($_POST["password"], $stored["password_hash"])
) {
    login();
    header("Location: ../dashboard.php");
    exit;
} else {
    $_SESSION['attempts']++;
    header("Location: ../../index.php");
    exit;
}
